<?php

namespace Tests\Feature;

use App\Models\Tenant;
use App\Models\User;
use Illuminate\Foundation\Testing\RefreshDatabase;
use Tests\TestCase;

class SettingsApiTest extends TestCase
{
    use RefreshDatabase;

    protected User $user;
    protected Tenant $tenant;

    protected function setUp(): void
    {
        parent::setUp();
        $this->tenant = Tenant::factory()->create();
        $this->user = User::factory()->create(['tenant_id' => $this->tenant->id]);
    }

    public function test_can_get_company_settings(): void
    {
        $response = $this->actingAs($this->user)->getJson('/api/settings/company');

        $response->assertOk()
            ->assertJsonStructure(['data' => ['name', 'email', 'phone']]);
    }

    public function test_can_update_company_settings(): void
    {
        $response = $this->actingAs($this->user)->putJson('/api/settings/company', [
            'name' => 'Updated Company',
            'phone' => '+973 1234 5678',
            'address' => 'Manama, Bahrain',
        ]);

        $response->assertOk();
        $this->assertEquals('Updated Company', $this->tenant->fresh()->name);
    }

    public function test_can_get_regional_settings(): void
    {
        $response = $this->actingAs($this->user)->getJson('/api/settings/regional');

        $response->assertOk()
            ->assertJsonStructure(['data' => ['timezone', 'currency', 'date_format']]);
    }

    public function test_can_update_invoice_settings(): void
    {
        $response = $this->actingAs($this->user)->putJson('/api/settings/invoice', [
            'prefix' => 'INV-',
            'next_number' => 1001,
            'due_days' => 30,
            'notes' => 'Thank you for your business!',
        ]);

        $response->assertOk();
    }
}
