import { defineStore } from 'pinia';
import api from '../api';

export const useInvoiceStore = defineStore('invoices', {
    state: () => ({
        invoices: [],
        invoice: null,
        pagination: null,
        loading: false,
        summary: null,
    }),

    actions: {
        async fetchInvoices(params = {}) {
            this.loading = true;
            try {
                const { data } = await api.get('/invoices', { params });
                this.invoices = data.data;
                this.pagination = data.meta;
            } finally {
                this.loading = false;
            }
        },

        async fetchInvoice(id) {
            this.loading = true;
            try {
                const { data } = await api.get(`/invoices/${id}`);
                this.invoice = data.data;
            } finally {
                this.loading = false;
            }
        },

        async createInvoice(invoiceData) {
            const { data } = await api.post('/invoices', invoiceData);
            return data.data;
        },

        async updateInvoice(id, invoiceData) {
            const { data } = await api.put(`/invoices/${id}`, invoiceData);
            return data.data;
        },

        async sendInvoice(id) {
            const { data } = await api.post(`/invoices/${id}/send`);
            const index = this.invoices.findIndex(i => i.id === id);
            if (index !== -1) this.invoices[index] = data.data;
            return data.data;
        },

        async recordPayment(id, paymentData) {
            const { data } = await api.post(`/invoices/${id}/payment`, paymentData);
            return data.data;
        },

        async duplicateInvoice(id) {
            const { data } = await api.post(`/invoices/${id}/duplicate`);
            return data.data;
        },
    },
});
