import { defineStore } from 'pinia';
import api from '../api';

export const useDashboardStore = defineStore('dashboard', {
    state: () => ({
        stats: {
            revenue: 0,
            revenue_change: 0,
            outstanding: 0,
            pipeline_value: 0,
            tasks_due: 0,
            contacts_count: 0,
        },
        recentInvoices: [],
        recentActivities: [],
        pipelineOverview: [],
        isLoading: false,
        lastUpdated: null,
    }),

    getters: {
        formattedRevenue: (state) => `BHD ${state.stats.revenue.toFixed(3)}`,
        formattedOutstanding: (state) => `BHD ${state.stats.outstanding.toFixed(3)}`,
    },

    actions: {
        async fetchStats() {
            this.isLoading = true;
            try {
                const { data } = await api.get('/dashboard/stats');
                this.stats = data.data;
                this.lastUpdated = new Date();
            } finally {
                this.isLoading = false;
            }
        },

        async fetchRecentInvoices() {
            const { data } = await api.get('/invoices?limit=5&sort=-created_at');
            this.recentInvoices = data.data;
        },

        async fetchRecentActivities() {
            const { data } = await api.get('/activities?limit=10');
            this.recentActivities = data.data;
        },

        async fetchPipelineOverview() {
            const { data } = await api.get('/dashboard/pipeline');
            this.pipelineOverview = data.data;
        },

        async fetchAll() {
            await Promise.all([
                this.fetchStats(),
                this.fetchRecentInvoices(),
                this.fetchRecentActivities(),
                this.fetchPipelineOverview(),
            ]);
        },
    },
});
