<?php

namespace Database\Seeders;

use App\Models\ChartOfAccount;
use Illuminate\Database\Seeder;

class ChartOfAccountSeeder extends Seeder
{
    public function run(): void
    {
        $accounts = [
            // Assets (1000-1999)
            ['code' => '1000', 'name' => 'Cash', 'type' => 'asset', 'sub_type' => 'current_asset'],
            ['code' => '1010', 'name' => 'Petty Cash', 'type' => 'asset', 'sub_type' => 'current_asset'],
            ['code' => '1100', 'name' => 'Bank Account', 'type' => 'asset', 'sub_type' => 'bank'],
            ['code' => '1200', 'name' => 'Accounts Receivable', 'type' => 'asset', 'sub_type' => 'receivable'],
            ['code' => '1300', 'name' => 'Inventory', 'type' => 'asset', 'sub_type' => 'current_asset'],
            ['code' => '1400', 'name' => 'Prepaid Expenses', 'type' => 'asset', 'sub_type' => 'current_asset'],
            ['code' => '1500', 'name' => 'Fixed Assets', 'type' => 'asset', 'sub_type' => 'fixed_asset'],
            ['code' => '1510', 'name' => 'Equipment', 'type' => 'asset', 'sub_type' => 'fixed_asset'],
            ['code' => '1520', 'name' => 'Furniture', 'type' => 'asset', 'sub_type' => 'fixed_asset'],
            ['code' => '1590', 'name' => 'Accumulated Depreciation', 'type' => 'asset', 'sub_type' => 'fixed_asset'],
            
            // Liabilities (2000-2999)
            ['code' => '2000', 'name' => 'Accounts Payable', 'type' => 'liability', 'sub_type' => 'payable'],
            ['code' => '2100', 'name' => 'Accrued Expenses', 'type' => 'liability', 'sub_type' => 'current_liability'],
            ['code' => '2200', 'name' => 'VAT Payable', 'type' => 'liability', 'sub_type' => 'current_liability'],
            ['code' => '2300', 'name' => 'Payroll Liabilities', 'type' => 'liability', 'sub_type' => 'current_liability'],
            ['code' => '2400', 'name' => 'Short-term Loans', 'type' => 'liability', 'sub_type' => 'current_liability'],
            ['code' => '2500', 'name' => 'Long-term Loans', 'type' => 'liability', 'sub_type' => 'long_term_liability'],
            
            // Equity (3000-3999)
            ['code' => '3000', 'name' => 'Owner\'s Capital', 'type' => 'equity', 'sub_type' => 'equity'],
            ['code' => '3100', 'name' => 'Retained Earnings', 'type' => 'equity', 'sub_type' => 'equity'],
            ['code' => '3200', 'name' => 'Owner\'s Drawings', 'type' => 'equity', 'sub_type' => 'equity'],
            
            // Revenue (4000-4999)
            ['code' => '4000', 'name' => 'Sales Revenue', 'type' => 'revenue', 'sub_type' => 'income'],
            ['code' => '4100', 'name' => 'Service Revenue', 'type' => 'revenue', 'sub_type' => 'income'],
            ['code' => '4200', 'name' => 'Other Income', 'type' => 'revenue', 'sub_type' => 'other_income'],
            ['code' => '4300', 'name' => 'Interest Income', 'type' => 'revenue', 'sub_type' => 'other_income'],
            
            // Expenses (5000-5999)
            ['code' => '5000', 'name' => 'Cost of Goods Sold', 'type' => 'expense', 'sub_type' => 'cost_of_sales'],
            ['code' => '5100', 'name' => 'Salaries & Wages', 'type' => 'expense', 'sub_type' => 'expense'],
            ['code' => '5110', 'name' => 'Employee Benefits', 'type' => 'expense', 'sub_type' => 'expense'],
            ['code' => '5200', 'name' => 'Rent Expense', 'type' => 'expense', 'sub_type' => 'expense'],
            ['code' => '5300', 'name' => 'Utilities', 'type' => 'expense', 'sub_type' => 'expense'],
            ['code' => '5400', 'name' => 'Office Supplies', 'type' => 'expense', 'sub_type' => 'expense'],
            ['code' => '5500', 'name' => 'Marketing & Advertising', 'type' => 'expense', 'sub_type' => 'expense'],
            ['code' => '5600', 'name' => 'Professional Services', 'type' => 'expense', 'sub_type' => 'expense'],
            ['code' => '5700', 'name' => 'Insurance', 'type' => 'expense', 'sub_type' => 'expense'],
            ['code' => '5800', 'name' => 'Depreciation Expense', 'type' => 'expense', 'sub_type' => 'expense'],
            ['code' => '5900', 'name' => 'Miscellaneous Expense', 'type' => 'expense', 'sub_type' => 'expense'],
        ];

        foreach ($accounts as $account) {
            ChartOfAccount::updateOrCreate(
                ['code' => $account['code'], 'tenant_id' => null],
                array_merge($account, [
                    'is_active' => true,
                    'is_system' => true,
                ])
            );
        }
    }
}
