<?php

namespace Database\Factories;

use App\Models\Workflow;
use Illuminate\Database\Eloquent\Factories\Factory;

class WorkflowFactory extends Factory
{
    protected $model = Workflow::class;

    public function definition(): array
    {
        return [
            'name' => $this->faker->words(3, true) . ' Workflow',
            'description' => $this->faker->sentence(),
            'trigger' => [
                'type' => $this->faker->randomElement(['contact_created', 'form_submitted', 'tag_added']),
                'conditions' => [],
            ],
            'is_active' => false,
        ];
    }

    public function active(): static
    {
        return $this->state(fn(array $attributes) => [
            'is_active' => true,
        ]);
    }
}
