<?php

namespace Database\Factories;

use App\Models\Task;
use App\Models\Tenant;
use App\Models\User;
use Illuminate\Database\Eloquent\Factories\Factory;

class TimeEntryFactory extends Factory
{
    public function definition(): array
    {
        $start = $this->faker->dateTimeBetween('-7 days', 'now');
        $duration = $this->faker->numberBetween(15, 180);
        $end = (clone $start)->modify("+{$duration} minutes");

        return [
            'tenant_id' => Tenant::factory(),
            'user_id' => User::factory(),
            'task_id' => Task::factory(),
            'description' => $this->faker->sentence(),
            'start_time' => $start,
            'end_time' => $end,
            'duration' => $duration,
            'is_billable' => $this->faker->boolean(70),
            'is_running' => false,
        ];
    }

    public function running(): static
    {
        return $this->state(fn() => [
            'end_time' => null,
            'duration' => null,
            'is_running' => true,
        ]);
    }
}
