<?php

namespace Database\Factories;

use App\Models\TaskStatus;
use Illuminate\Database\Eloquent\Factories\Factory;

class TaskStatusFactory extends Factory
{
    protected $model = TaskStatus::class;

    public function definition(): array
    {
        return [
            'name' => $this->faker->randomElement(['To Do', 'In Progress', 'Review', 'Done']),
            'color' => $this->faker->hexColor(),
            'position' => $this->faker->numberBetween(1, 10),
            'is_default' => false,
            'is_completed' => false,
        ];
    }
}
