<?php

namespace Database\Factories;

use App\Models\LeaveRequest;
use Illuminate\Database\Eloquent\Factories\Factory;

class LeaveRequestFactory extends Factory
{
    protected $model = LeaveRequest::class;

    public function definition(): array
    {
        $startDate = $this->faker->dateTimeBetween('now', '+2 months');
        $endDate = (clone $startDate)->modify('+' . $this->faker->numberBetween(1, 5) . ' days');

        return [
            'start_date' => $startDate,
            'end_date' => $endDate,
            'days' => $this->faker->numberBetween(1, 5),
            'start_half_day' => false,
            'end_half_day' => false,
            'reason' => $this->faker->optional()->sentence(),
            'status' => 'pending',
        ];
    }
}
