<?php

namespace Database\Factories;

use App\Models\Invoice;
use Illuminate\Database\Eloquent\Factories\Factory;

class InvoiceFactory extends Factory
{
    protected $model = Invoice::class;

    public function definition(): array
    {
        $subtotal = $this->faker->randomFloat(3, 100, 10000);
        $taxRate = 10;
        $taxAmount = $subtotal * ($taxRate / 100);

        return [
            'invoice_number' => 'INV-' . str_pad($this->faker->unique()->numberBetween(1, 9999), 4, '0', STR_PAD_LEFT),
            'invoice_date' => $this->faker->dateTimeBetween('-3 months', 'now'),
            'due_date' => $this->faker->dateTimeBetween('now', '+30 days'),
            'currency' => 'BHD',
            'exchange_rate' => 1.0,
            'subtotal' => $subtotal,
            'discount_type' => null,
            'discount_value' => 0,
            'discount_amount' => 0,
            'tax_amount' => $taxAmount,
            'total' => $subtotal + $taxAmount,
            'amount_paid' => 0,
            'status' => 'draft',
            'notes' => $this->faker->optional()->sentence(),
            'terms' => 'Payment due within 30 days.',
        ];
    }
}
