<?php

namespace Database\Factories;

use App\Models\BankAccount;
use Illuminate\Database\Eloquent\Factories\Factory;

class BankAccountFactory extends Factory
{
    protected $model = BankAccount::class;

    public function definition(): array
    {
        return [
            'name' => $this->faker->words(2, true) . ' Account',
            'account_number' => $this->faker->bankAccountNumber(),
            'bank_name' => $this->faker->randomElement(['National Bank of Bahrain', 'Ahli United Bank', 'Bank of Bahrain and Kuwait']),
            'account_type' => $this->faker->randomElement(['checking', 'savings']),
            'currency' => 'BHD',
            'current_balance' => $this->faker->randomFloat(3, 1000, 100000),
            'is_active' => true,
        ];
    }
}
