<?php

namespace Database\Factories;

use App\Models\Employee;
use App\Models\Tenant;
use Illuminate\Database\Eloquent\Factories\Factory;

class AttendanceFactory extends Factory
{
    public function definition(): array
    {
        $checkIn = $this->faker->time('H:i:s', '09:30:00');
        $checkOut = $this->faker->time('H:i:s', '17:30:00');
        
        return [
            'tenant_id' => Tenant::factory(),
            'employee_id' => Employee::factory(),
            'date' => $this->faker->dateTimeBetween('-30 days', 'now')->format('Y-m-d'),
            'check_in' => $checkIn,
            'check_out' => $checkOut,
            'status' => $checkIn > '09:00:00' ? 'late' : 'present',
            'hours_worked' => $this->faker->randomFloat(2, 6, 9),
        ];
    }
}
