<?php

namespace App\Providers;

use Illuminate\Foundation\Support\Providers\AuthServiceProvider as ServiceProvider;

class AuthServiceProvider extends ServiceProvider
{
    protected $policies = [
        \App\Models\Contact::class => \App\Policies\ContactPolicy::class,
        \App\Models\Invoice::class => \App\Policies\InvoicePolicy::class,
        \App\Models\Estimate::class => \App\Policies\EstimatePolicy::class,
        \App\Models\Bill::class => \App\Policies\BillPolicy::class,
        \App\Models\Project::class => \App\Policies\ProjectPolicy::class,
        \App\Models\Task::class => \App\Policies\TaskPolicy::class,
        \App\Models\Employee::class => \App\Policies\EmployeePolicy::class,
        \App\Models\Opportunity::class => \App\Policies\OpportunityPolicy::class,
    ];

    public function boot(): void
    {
        $this->registerPolicies();
    }
}
