<?php

namespace App\Policies;

use App\Models\TimeEntry;
use App\Models\User;

class TimeEntryPolicy
{
    public function viewAny(User $user): bool
    {
        return true;
    }

    public function view(User $user, TimeEntry $entry): bool
    {
        return $user->tenant_id === $entry->tenant_id;
    }

    public function create(User $user): bool
    {
        return true;
    }

    public function update(User $user, TimeEntry $entry): bool
    {
        return $user->id === $entry->user_id || $user->hasPermissionTo('time.manage');
    }

    public function delete(User $user, TimeEntry $entry): bool
    {
        return $user->id === $entry->user_id || $user->hasPermissionTo('time.manage');
    }
}
