<?php

namespace App\Policies;

use App\Models\Task;
use App\Models\User;

class TaskPolicy
{
    public function viewAny(User $user): bool
    {
        return true;
    }

    public function view(User $user, Task $task): bool
    {
        if ($user->tenant_id !== $task->tenant_id) {
            return false;
        }

        return $user->can('view', $task->project);
    }

    public function create(User $user): bool
    {
        return true;
    }

    public function update(User $user, Task $task): bool
    {
        if ($user->tenant_id !== $task->tenant_id) {
            return false;
        }

        $member = $task->project->members()->where('user_id', $user->id)->first();
        return $member && in_array($member->role, ['member', 'manager', 'admin']);
    }

    public function delete(User $user, Task $task): bool
    {
        if ($user->tenant_id !== $task->tenant_id) {
            return false;
        }

        $member = $task->project->members()->where('user_id', $user->id)->first();
        return $member && in_array($member->role, ['manager', 'admin']);
    }

    public function assign(User $user, Task $task): bool
    {
        return $this->update($user, $task);
    }
}
