<?php

namespace App\Policies;

use App\Models\Estimate;
use App\Models\User;

class EstimatePolicy
{
    public function viewAny(User $user): bool
    {
        return true;
    }

    public function view(User $user, Estimate $estimate): bool
    {
        return $user->tenant_id === $estimate->tenant_id;
    }

    public function create(User $user): bool
    {
        return true;
    }

    public function update(User $user, Estimate $estimate): bool
    {
        return $user->tenant_id === $estimate->tenant_id && 
               in_array($estimate->status, ['draft', 'sent']);
    }

    public function delete(User $user, Estimate $estimate): bool
    {
        return $user->tenant_id === $estimate->tenant_id && 
               $estimate->status === 'draft';
    }

    public function convert(User $user, Estimate $estimate): bool
    {
        return $user->tenant_id === $estimate->tenant_id && 
               $estimate->status === 'accepted';
    }
}
