<?php

namespace App\Policies;

use App\Models\Bill;
use App\Models\User;

class BillPolicy
{
    public function viewAny(User $user): bool
    {
        return true;
    }

    public function view(User $user, Bill $bill): bool
    {
        return $user->tenant_id === $bill->tenant_id;
    }

    public function create(User $user): bool
    {
        return true;
    }

    public function update(User $user, Bill $bill): bool
    {
        return $user->tenant_id === $bill->tenant_id && 
               $bill->status !== 'paid';
    }

    public function delete(User $user, Bill $bill): bool
    {
        return $user->tenant_id === $bill->tenant_id && 
               $bill->amount_paid == 0;
    }

    public function recordPayment(User $user, Bill $bill): bool
    {
        return $user->tenant_id === $bill->tenant_id && 
               $bill->status !== 'paid';
    }
}
