<?php

namespace App\Notifications;

use App\Models\Employee;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;

class WelcomeEmployeeNotification extends Notification implements ShouldQueue
{
    use Queueable;

    public function __construct(protected Employee $employee) {}

    public function via(object $notifiable): array
    {
        return ['mail'];
    }

    public function toMail(object $notifiable): MailMessage
    {
        return (new MailMessage)
            ->subject('Welcome to the Team!')
            ->greeting("Hello {$this->employee->user->first_name}!")
            ->line('We are excited to have you join our team.')
            ->line("Your employee ID is: {$this->employee->employee_id}")
            ->line("Your start date is: {$this->employee->hire_date->format('M d, Y')}")
            ->action('Access Your Dashboard', url('/dashboard'))
            ->line('Please reach out to HR if you have any questions.');
    }
}
