<?php

namespace App\Notifications;

use App\Models\Opportunity;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;

class OpportunityWonNotification extends Notification implements ShouldQueue
{
    use Queueable;

    public function __construct(public Opportunity $opportunity) {}

    public function via($notifiable): array
    {
        return ['mail', 'database'];
    }

    public function toMail($notifiable): MailMessage
    {
        return (new MailMessage)
            ->subject("🎉 Opportunity Won: {$this->opportunity->name}")
            ->greeting("Congratulations {$notifiable->first_name}!")
            ->line("Great news! The opportunity \"{$this->opportunity->name}\" has been marked as won.")
            ->line("Deal Value: {$this->opportunity->currency} " . number_format($this->opportunity->value, 3))
            ->line("Contact: {$this->opportunity->contact->full_name}")
            ->action('View Opportunity', url("/opportunities/{$this->opportunity->id}"))
            ->line('Keep up the great work!');
    }

    public function toArray($notifiable): array
    {
        return [
            'type' => 'opportunity_won',
            'opportunity_id' => $this->opportunity->id,
            'name' => $this->opportunity->name,
            'value' => $this->opportunity->value,
            'contact' => $this->opportunity->contact->full_name,
        ];
    }
}
