<?php

namespace App\Notifications;

use App\Models\LeaveRequest;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;

class LeaveRequestSubmittedNotification extends Notification implements ShouldQueue
{
    use Queueable;

    public function __construct(public LeaveRequest $leaveRequest) {}

    public function via($notifiable): array
    {
        return ['mail', 'database'];
    }

    public function toMail($notifiable): MailMessage
    {
        $employee = $this->leaveRequest->employee;
        
        return (new MailMessage)
            ->subject('Leave Request from ' . $employee->full_name)
            ->line($employee->full_name . ' has submitted a leave request.')
            ->line('Type: ' . $this->leaveRequest->leaveType->name)
            ->line('From: ' . $this->leaveRequest->start_date->format('M d, Y'))
            ->line('To: ' . $this->leaveRequest->end_date->format('M d, Y'))
            ->line('Days: ' . $this->leaveRequest->days)
            ->action('Review Request', url('/leave-requests/' . $this->leaveRequest->id));
    }

    public function toArray($notifiable): array
    {
        return [
            'type' => 'leave_request_submitted',
            'leave_request_id' => $this->leaveRequest->id,
            'employee_name' => $this->leaveRequest->employee->full_name,
        ];
    }
}
