<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class SmartList extends BaseModel
{
    use HasFactory;

    protected $fillable = [
        'tenant_id',
        'name',
        'description',
        'filters',
        'is_default',
        'created_by',
    ];

    protected $casts = [
        'filters' => 'array',
        'is_default' => 'boolean',
    ];

    public function createdBy(): BelongsTo
    {
        return $this->belongsTo(User::class, 'created_by');
    }

    public function getContacts()
    {
        $query = Contact::where('tenant_id', $this->tenant_id);

        foreach ($this->filters ?? [] as $filter) {
            $field = $filter['field'];
            $operator = $filter['operator'];
            $value = $filter['value'];

            match ($operator) {
                'equals' => $query->where($field, $value),
                'not_equals' => $query->where($field, '!=', $value),
                'contains' => $query->where($field, 'like', "%{$value}%"),
                'starts_with' => $query->where($field, 'like', "{$value}%"),
                'ends_with' => $query->where($field, 'like', "%{$value}"),
                'is_empty' => $query->whereNull($field)->orWhere($field, ''),
                'is_not_empty' => $query->whereNotNull($field)->where($field, '!=', ''),
                'greater_than' => $query->where($field, '>', $value),
                'less_than' => $query->where($field, '<', $value),
                'in' => $query->whereIn($field, (array) $value),
                default => null,
            };
        }

        return $query;
    }

    public function getCount(): int
    {
        return $this->getContacts()->count();
    }
}
