<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;

class Segment extends BaseModel
{
    use HasFactory;

    protected $fillable = [
        'tenant_id', 'name', 'description', 'is_dynamic', 'conditions',
    ];

    protected $casts = [
        'is_dynamic' => 'boolean',
        'conditions' => 'array',
    ];

    public function contacts(): BelongsToMany
    {
        return $this->belongsToMany(Contact::class, 'contact_segment');
    }

    public function campaigns(): BelongsToMany
    {
        return $this->belongsToMany(Campaign::class, 'campaign_segment');
    }

    public function refreshContacts(): void
    {
        if (!$this->is_dynamic) return;

        $query = Contact::where('tenant_id', $this->tenant_id);

        foreach ($this->conditions as $condition) {
            $query = $this->applyCondition($query, $condition);
        }

        $this->contacts()->sync($query->pluck('id'));
    }

    protected function applyCondition($query, array $condition)
    {
        $field = $condition['field'];
        $operator = $condition['operator'];
        $value = $condition['value'];

        return match ($operator) {
            'equals' => $query->where($field, $value),
            'not_equals' => $query->where($field, '!=', $value),
            'contains' => $query->where($field, 'like', "%{$value}%"),
            'greater_than' => $query->where($field, '>', $value),
            'less_than' => $query->where($field, '<', $value),
            default => $query,
        };
    }
}
