<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class InvoiceItem extends BaseModel
{
    use HasFactory;

    protected $fillable = [
        'tenant_id',
        'invoice_id',
        'product_id',
        'name',
        'description',
        'quantity',
        'unit_price',
        'discount_type',
        'discount_value',
        'discount_amount',
        'tax_rate_id',
        'tax_amount',
        'subtotal',
        'total',
        'position',
    ];

    protected $casts = [
        'quantity' => 'decimal:4',
        'unit_price' => 'decimal:3',
        'discount_value' => 'decimal:2',
        'discount_amount' => 'decimal:3',
        'tax_amount' => 'decimal:3',
        'subtotal' => 'decimal:3',
        'total' => 'decimal:3',
        'position' => 'integer',
    ];

    public function invoice(): BelongsTo
    {
        return $this->belongsTo(Invoice::class);
    }

    public function product(): BelongsTo
    {
        return $this->belongsTo(Product::class);
    }

    public function taxRate(): BelongsTo
    {
        return $this->belongsTo(TaxRate::class);
    }

    public function calculateTotals(): void
    {
        $this->subtotal = $this->quantity * $this->unit_price;
        
        if ($this->discount_type === 'percentage') {
            $this->discount_amount = $this->subtotal * ($this->discount_value / 100);
        } else {
            $this->discount_amount = $this->discount_value ?? 0;
        }
        
        $taxableAmount = $this->subtotal - $this->discount_amount;
        
        if ($this->taxRate) {
            $this->tax_amount = $taxableAmount * ($this->taxRate->rate / 100);
        } else {
            $this->tax_amount = 0;
        }
        
        $this->total = $taxableAmount + $this->tax_amount;
    }
}
