<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use App\Traits\BelongsToTenant;

abstract class BaseModel extends Model
{
    use HasFactory, BelongsToTenant;

    protected $guarded = ['id'];

    protected static function booted(): void
    {
        static::creating(function ($model) {
            if (auth()->check() && !$model->tenant_id && $model->hasTenantColumn()) {
                $model->tenant_id = auth()->user()->tenant_id;
            }
        });
    }

    protected function hasTenantColumn(): bool
    {
        return in_array('tenant_id', $this->getFillable()) || 
               $this->getConnection()->getSchemaBuilder()->hasColumn($this->getTable(), 'tenant_id');
    }
}
