<?php

namespace App\Listeners;

use App\Events\CampaignSent;
use Illuminate\Contracts\Queue\ShouldQueue;

class UpdateCampaignStats implements ShouldQueue
{
    public function handle(CampaignSent $event): void
    {
        $campaign = $event->campaign;
        $campaign->recipient_count = $campaign->recipients()->count();
        $campaign->sent_count = $campaign->recipients()->where('status', 'sent')->count();
        $campaign->save();
    }
}
