<?php

namespace App\Listeners;

use App\Events\TaskDueSoon;
use App\Notifications\TaskDueSoonNotification;
use Illuminate\Contracts\Queue\ShouldQueue;

class SendTaskDueNotification implements ShouldQueue
{
    public function handle(TaskDueSoon $event): void
    {
        foreach ($event->task->assignees as $assignee) {
            $assignee->user->notify(new TaskDueSoonNotification($event->task, $event->daysUntilDue));
        }
    }
}
