<?php

namespace App\Listeners;

use App\Events\OpportunityWon;
use App\Notifications\OpportunityWonNotification;

class SendOpportunityWonNotification
{
    public function handle(OpportunityWon $event): void
    {
        $opportunity = $event->opportunity;
        $owner = $opportunity->owner;

        if ($owner) {
            $owner->notify(new OpportunityWonNotification($opportunity));
        }
    }
}
