<?php

namespace App\Listeners;

use App\Events\InvoicePaid;
use App\Notifications\PaymentReceivedNotification;
use Illuminate\Contracts\Queue\ShouldQueue;

class SendInvoicePaidNotification implements ShouldQueue
{
    public function handle(InvoicePaid $event): void
    {
        $invoice = $event->invoice;
        $invoice->createdBy?->notify(new PaymentReceivedNotification($invoice, $event->payment));
    }
}
