<?php

namespace App\Jobs;

use App\Models\Contact;
use App\Models\FormSubmission;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;

class SyncContactFromForm implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    public function __construct(protected FormSubmission $submission) {}

    public function handle(): void
    {
        $data = $this->submission->data;
        
        $email = $data['email'] ?? null;
        if (!$email) return;

        $contact = Contact::firstOrNew([
            'tenant_id' => $this->submission->tenant_id,
            'email' => $email,
        ]);

        $contact->fill([
            'first_name' => $data['first_name'] ?? $data['name'] ?? 'Unknown',
            'last_name' => $data['last_name'] ?? '',
            'phone' => $data['phone'] ?? $contact->phone,
            'company_name' => $data['company'] ?? $data['company_name'] ?? $contact->company_name,
            'source' => 'form',
            'lead_status' => $contact->exists ? $contact->lead_status : 'new',
        ]);

        $contact->save();

        $this->submission->update(['contact_id' => $contact->id]);
    }
}
