<?php

namespace App\Jobs;

use App\Models\Campaign;
use App\Models\CampaignRecipient;
use App\Services\EmailService;
use App\Services\SmsService;
use App\Services\WhatsappService;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use Illuminate\Support\Collection;

class SendCampaignBatch implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    public function __construct(
        public Campaign $campaign,
        public Collection $recipientIds
    ) {}

    public function handle(EmailService $emailService, SmsService $smsService, WhatsappService $whatsappService): void
    {
        $recipients = CampaignRecipient::whereIn('id', $this->recipientIds)
            ->where('status', 'pending')
            ->with('contact')
            ->get();

        foreach ($recipients as $recipient) {
            try {
                match ($this->campaign->type) {
                    'email' => $emailService->sendCampaignEmail($this->campaign, $recipient),
                    'sms' => $smsService->sendCampaignSms($this->campaign, $recipient),
                    'whatsapp' => $whatsappService->sendCampaignWhatsapp($this->campaign, $recipient),
                };

                $recipient->update(['status' => 'sent', 'sent_at' => now()]);
                $this->campaign->increment('sent_count');
            } catch (\Exception $e) {
                $recipient->update(['status' => 'failed', 'error' => $e->getMessage()]);
            }
        }
    }
}
