<?php

namespace App\Jobs;

use App\Models\RecurringInvoice;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;

class GenerateRecurringInvoices implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    public function handle(): void
    {
        RecurringInvoice::where('status', 'active')
            ->where('next_invoice_date', '<=', now())
            ->each(function ($recurring) {
                $recurring->generateInvoice();
            });
    }
}
