<?php

namespace App\Jobs;

use App\Services\ExportService;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;

class ExportData implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    public $timeout = 1800;

    public function __construct(
        public int $tenantId,
        public string $type,
        public array $filters,
        public int $userId
    ) {}

    public function handle(ExportService $exportService): void
    {
        $exportService->export(
            $this->tenantId,
            $this->type,
            $this->filters,
            $this->userId
        );
    }
}
