<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class UpdateWorkflowRequest extends FormRequest
{
    public function authorize(): bool
    {
        return $this->user()->tenant_id === $this->route('workflow')->tenant_id;
    }

    public function rules(): array
    {
        return [
            'name' => 'sometimes|string|max:255',
            'description' => 'nullable|string|max:500',
            'trigger_type' => 'sometimes|in:contact_created,form_submitted,tag_added,opportunity_won,manual',
            'trigger_conditions' => 'nullable|array',
            'steps' => 'sometimes|array',
            'steps.*.type' => 'required_with:steps|in:send_email,send_sms,add_tag,remove_tag,wait,webhook,update_field',
            'steps.*.config' => 'required_with:steps|array',
            'steps.*.delay_minutes' => 'nullable|integer|min:0',
            'is_active' => 'boolean',
        ];
    }
}
