<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class UpdateProjectRequest extends FormRequest
{
    public function authorize(): bool
    {
        return $this->user()->tenant_id === $this->route('project')->tenant_id;
    }

    public function rules(): array
    {
        return [
            'name' => 'sometimes|string|max:255',
            'description' => 'nullable|string|max:2000',
            'start_date' => 'nullable|date',
            'due_date' => 'nullable|date|after_or_equal:start_date',
            'status' => 'nullable|in:active,on_hold,completed,archived',
            'budget' => 'nullable|numeric|min:0',
            'budget_type' => 'nullable|in:fixed,hourly',
            'hourly_rate' => 'nullable|numeric|min:0',
            'is_billable' => 'boolean',
            'client_id' => 'nullable|exists:contacts,id',
        ];
    }
}
