<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class UpdateEmployeeRequest extends FormRequest
{
    public function authorize(): bool
    {
        return $this->user()->tenant_id === $this->route('employee')->tenant_id;
    }

    public function rules(): array
    {
        return [
            'department_id' => 'nullable|exists:departments,id',
            'manager_id' => 'nullable|exists:employees,id',
            'job_title' => 'sometimes|string|max:255',
            'employment_type' => 'sometimes|in:full_time,part_time,contract,intern',
            'work_location' => 'nullable|string|max:255',
            'nationality' => 'nullable|string|size:2',
            'date_of_birth' => 'nullable|date|before:today',
            'gender' => 'nullable|in:male,female,other',
            'marital_status' => 'nullable|in:single,married,divorced,widowed',
            'cpr_number' => 'nullable|string|max:20',
            'passport_number' => 'nullable|string|max:20',
            'passport_expiry' => 'nullable|date',
            'visa_status' => 'nullable|string|max:50',
            'visa_expiry' => 'nullable|date',
            'emergency_contact_name' => 'nullable|string|max:255',
            'emergency_contact_phone' => 'nullable|string|max:50',
            'emergency_contact_relation' => 'nullable|string|max:50',
            'bank_name' => 'nullable|string|max:255',
            'bank_account_number' => 'nullable|string|max:50',
            'bank_iban' => 'nullable|string|max:50',
            'status' => 'sometimes|in:active,on_leave,probation,terminated',
            'termination_date' => 'nullable|date',
            'termination_reason' => 'nullable|string|max:500',
        ];
    }
}
