<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class StoreWorkflowRequest extends FormRequest
{
    public function authorize(): bool
    {
        return true;
    }

    public function rules(): array
    {
        return [
            'name' => 'required|string|max:255',
            'description' => 'nullable|string|max:1000',
            'trigger' => 'required|array',
            'trigger.type' => 'required|string|in:contact_created,contact_updated,form_submitted,tag_added,opportunity_stage_changed,opportunity_won,opportunity_lost',
            'trigger.conditions' => 'nullable|array',
            'trigger.conditions.*.field' => 'required_with:trigger.conditions|string',
            'trigger.conditions.*.operator' => 'required_with:trigger.conditions|string',
            'trigger.conditions.*.value' => 'required_with:trigger.conditions',
            'steps' => 'required|array|min:1',
            'steps.*.type' => 'required|string|in:send_email,send_sms,send_whatsapp,add_tag,remove_tag,update_field,create_task,webhook,wait,if_else',
            'steps.*.config' => 'required|array',
            'steps.*.delay' => 'nullable|array',
            'steps.*.delay.value' => 'required_with:steps.*.delay|integer|min:1',
            'steps.*.delay.unit' => 'required_with:steps.*.delay|in:minutes,hours,days,weeks',
        ];
    }
}
