<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class StorePayrollRunRequest extends FormRequest
{
    public function authorize(): bool
    {
        return $this->user()->hasPermissionTo('payroll.create');
    }

    public function rules(): array
    {
        return [
            'pay_period_start' => 'required|date',
            'pay_period_end' => 'required|date|after:pay_period_start',
            'payment_date' => 'required|date|after_or_equal:pay_period_end',
            'notes' => 'nullable|string|max:500',
        ];
    }

    public function messages(): array
    {
        return [
            'pay_period_end.after' => 'Pay period end must be after pay period start.',
            'payment_date.after_or_equal' => 'Payment date must be on or after pay period end.',
        ];
    }
}
