<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class StoreBankAccountRequest extends FormRequest
{
    public function authorize(): bool
    {
        return true;
    }

    public function rules(): array
    {
        return [
            'name' => 'required|string|max:255',
            'account_number' => 'required|string|max:50',
            'bank_name' => 'required|string|max:255',
            'account_type' => 'required|in:checking,savings,credit_card,money_market',
            'currency' => 'required|string|size:3',
            'opening_balance' => 'nullable|numeric',
            'opening_balance_date' => 'nullable|date',
            'chart_account_id' => 'nullable|exists:chart_of_accounts,id',
            'iban' => 'nullable|string|max:50',
            'swift_code' => 'nullable|string|max:20',
            'branch_name' => 'nullable|string|max:255',
            'branch_address' => 'nullable|string|max:500',
        ];
    }
}
