<?php

namespace App\Http\Requests\Api;

use Illuminate\Foundation\Http\FormRequest;

class StorePaymentRequest extends FormRequest
{
    public function authorize(): bool { return true; }

    public function rules(): array
    {
        return [
            'contact_id' => 'required|exists:contacts,id',
            'invoice_id' => 'nullable|exists:invoices,id',
            'bank_account_id' => 'nullable|exists:bank_accounts,id',
            'payment_date' => 'required|date',
            'amount' => 'required|numeric|min:0.001',
            'currency' => 'nullable|string|size:3',
            'payment_method' => 'required|string|max:50',
            'reference' => 'nullable|string|max:255',
            'description' => 'nullable|string|max:1000',
        ];
    }
}
