<?php

namespace App\Http\Requests\Api;

use Illuminate\Foundation\Http\FormRequest;

class StoreFormRequest extends FormRequest
{
    public function authorize(): bool { return true; }

    public function rules(): array
    {
        return [
            'name' => 'required|string|max:255',
            'description' => 'nullable|string|max:1000',
            'fields' => 'required|array|min:1',
            'fields.*.type' => 'required|in:text,email,phone,textarea,select,checkbox,radio,date,number,file',
            'fields.*.name' => 'required|string|max:100',
            'fields.*.label' => 'required|string|max:255',
            'fields.*.required' => 'nullable|boolean',
            'fields.*.options' => 'nullable|array',
            'fields.*.placeholder' => 'nullable|string|max:255',
            'settings' => 'nullable|array',
            'style' => 'nullable|array',
            'redirect_url' => 'nullable|url|max:500',
            'thank_you_message' => 'nullable|string|max:1000',
            'workflow_id' => 'nullable|exists:workflows,id',
        ];
    }
}
