<?php

namespace App\Http\Requests\Api;

use Illuminate\Foundation\Http\FormRequest;

class StoreExpenseRequest extends FormRequest
{
    public function authorize(): bool { return true; }

    public function rules(): array
    {
        return [
            'account_id' => 'required|exists:chart_of_accounts,id',
            'vendor_id' => 'nullable|exists:vendors,id',
            'contact_id' => 'nullable|exists:contacts,id',
            'expense_date' => 'required|date',
            'amount' => 'required|numeric|min:0.001',
            'currency' => 'nullable|string|size:3',
            'tax_rate_id' => 'nullable|exists:tax_rates,id',
            'category' => 'nullable|string|max:100',
            'description' => 'nullable|string|max:1000',
            'receipt' => 'nullable|file|mimes:jpg,jpeg,png,pdf|max:5120',
            'is_billable' => 'nullable|boolean',
            'is_reimbursable' => 'nullable|boolean',
            'payment_method' => 'nullable|string|max:50',
            'reference' => 'nullable|string|max:255',
        ];
    }
}
