<?php

namespace App\Http\Requests\Api;

use Illuminate\Foundation\Http\FormRequest;

class StoreCampaignRequest extends FormRequest
{
    public function authorize(): bool { return true; }

    public function rules(): array
    {
        return [
            'name' => 'required|string|max:255',
            'type' => 'required|in:email,sms,whatsapp',
            'subject' => 'required_if:type,email|string|max:255',
            'content' => 'required|string',
            'from_name' => 'nullable|string|max:255',
            'from_email' => 'nullable|email|max:255',
            'reply_to' => 'nullable|email|max:255',
            'template_id' => 'nullable|exists:email_templates,id',
            'email_account_id' => 'nullable|exists:email_accounts,id',
            'audience_filters' => 'nullable|array',
            'settings' => 'nullable|array',
            'scheduled_at' => 'nullable|date|after:now',
        ];
    }
}
