<?php

namespace App\Http\Requests\Api;

use Illuminate\Foundation\Http\FormRequest;

class SendSmsRequest extends FormRequest
{
    public function authorize(): bool { return true; }

    public function rules(): array
    {
        return [
            'to' => 'required|string|max:20',
            'message' => 'required|string|max:1600',
            'contact_id' => 'nullable|exists:contacts,id',
            'from_number' => 'nullable|string|max:20',
        ];
    }
}
