<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Services\ReportService;
use Illuminate\Http\Request;

class ReportController extends Controller
{
    public function __construct(protected ReportService $reportService) {}

    public function balanceSheet(Request $request)
    {
        $asOfDate = $request->input('as_of_date', now()->toDateString());
        
        $report = $this->reportService->generateBalanceSheet(
            $request->user()->tenant_id,
            $asOfDate
        );

        return response()->json(['data' => $report]);
    }

    public function profitAndLoss(Request $request)
    {
        $startDate = $request->input('start_date', now()->startOfMonth()->toDateString());
        $endDate = $request->input('end_date', now()->toDateString());
        
        $report = $this->reportService->generateProfitAndLoss(
            $request->user()->tenant_id,
            $startDate,
            $endDate
        );

        return response()->json(['data' => $report]);
    }

    public function cashFlow(Request $request)
    {
        $period = $request->input('period', 'this_month');
        
        $report = $this->reportService->generateCashFlow(
            $request->user()->tenant_id,
            $period
        );

        return response()->json(['data' => $report]);
    }

    public function agingReceivables(Request $request)
    {
        $report = $this->reportService->generateAgingReceivables(
            $request->user()->tenant_id
        );

        return response()->json(['data' => $report]);
    }

    public function agingPayables(Request $request)
    {
        $report = $this->reportService->generateAgingPayables(
            $request->user()->tenant_id
        );

        return response()->json(['data' => $report]);
    }

    public function salesReport(Request $request)
    {
        $startDate = $request->input('start_date', now()->startOfMonth()->toDateString());
        $endDate = $request->input('end_date', now()->toDateString());
        
        $report = $this->reportService->generateSalesReport(
            $request->user()->tenant_id,
            $startDate,
            $endDate
        );

        return response()->json(['data' => $report]);
    }

    public function taxReport(Request $request)
    {
        $startDate = $request->input('start_date', now()->startOfYear()->toDateString());
        $endDate = $request->input('end_date', now()->toDateString());
        
        $report = $this->reportService->generateTaxReport(
            $request->user()->tenant_id,
            $startDate,
            $endDate
        );

        return response()->json(['data' => $report]);
    }
}
