# 🔗 Hostinger Setup Guide

## Option 1: VPS Hosting (Recommended)

### Step 1: Enable SSH Access
1. Login to Hostinger hPanel
2. Go to **Advanced → SSH Access**
3. Enable SSH and note your credentials

### Step 2: Configure Sync Script
Edit `sync-to-hostinger.sh` and update:
```bash
HOSTINGER_HOST="your-vps-ip"      # e.g., 185.199.xxx.xxx
HOSTINGER_USER="root"              # or your username
HOSTINGER_PATH="/var/www/html"     # your web root
HOSTINGER_PORT="22"                # SSH port
```

### Step 3: Setup SSH Key (Optional but recommended)
```bash
# On your local machine / Claude
ssh-keygen -t rsa -b 4096
ssh-copy-id -p 22 root@your-vps-ip
```

### Step 4: First Deployment
```bash
./sync-to-hostinger.sh
```

---

## Option 2: Shared Hosting with Git

### Step 1: Enable Git in hPanel
1. Go to **Advanced → Git**
2. Create repository
3. Note the Git URL

### Step 2: Push from Claude
```bash
git remote add hostinger ssh://your-git-url
git push hostinger main
```

### Step 3: Auto-deploy webhook
Hostinger will auto-deploy on push

---

## Option 3: FTP/SFTP (Simplest)

### Step 1: Get FTP Credentials
1. Go to **Files → FTP Accounts**
2. Create or use existing account

### Step 2: Use SFTP to sync
```bash
sftp username@your-domain.com
put -r * /public_html/
```

---

## Database Setup

### Create MySQL Database
1. Go to **Databases → MySQL Databases**
2. Create database: `business_platform`
3. Create user and assign to database
4. Note credentials

### Update .env on Server
```env
DB_CONNECTION=mysql
DB_HOST=localhost
DB_PORT=3306
DB_DATABASE=business_platform
DB_USERNAME=your_db_user
DB_PASSWORD=your_db_password
```

### Run Migrations
```bash
ssh your-server
cd /path/to/app
php artisan migrate --seed
```

---

## SSL Certificate
1. Go to **Security → SSL**
2. Install free Let's Encrypt certificate
3. Force HTTPS redirect

---

## Cron Jobs (for scheduled tasks)
1. Go to **Advanced → Cron Jobs**
2. Add: `* * * * * cd /path/to/app && php artisan schedule:run >> /dev/null 2>&1`

---

## Queue Worker
For VPS, create systemd service:
```bash
sudo nano /etc/systemd/system/laravel-queue.service
```

```ini
[Unit]
Description=Laravel Queue Worker

[Service]
User=www-data
WorkingDirectory=/var/www/html
ExecStart=/usr/bin/php artisan queue:work --sleep=3 --tries=3
Restart=always

[Install]
WantedBy=multi-user.target
```

```bash
sudo systemctl enable laravel-queue
sudo systemctl start laravel-queue
```

---

## Quick Commands Reference

| Action | Command |
|--------|---------|
| Sync files | `./sync-to-hostinger.sh` |
| SSH to server | `ssh user@your-server` |
| Run migrations | `php artisan migrate` |
| Clear cache | `php artisan cache:clear` |
| View logs | `tail -f storage/logs/laravel.log` |

